/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.JCScrolledWindow;
import jclass.bwt.JCTextComponent;
import jclass.bwt.TextAreaConverter;
import jclass.bwt.TextLine;
import jclass.util.JCFile;
import jclass.util.JCVector;

public class JCTextAreaComponent
extends JCTextComponent
implements JCScrollableInterface {
    int rows = 5;
    boolean multiline = true;
    protected transient JCScrolledWindow scrolled_window;
    protected boolean update_scrollbars = true;
    int top_row;
    int top_char;
    int bottom_row = -999;
    int widest_row = -999;
    int original_bottom_margin;
    transient JCVector lines;
    private static final String base = "text";
    private static int nameCounter;
    protected int visible_rows;
    Rectangle draw_rect = new Rectangle();
    Image buffer_image;
    Graphics buffer_image_gc;

    public JCTextAreaComponent() {
        this("", 5, 20);
    }

    public JCTextAreaComponent(String string) {
        this(string, 5, 20);
    }

    public JCTextAreaComponent(String string, int n, int n2) {
        this(string, null, null);
        this.rows = n;
        this.columns = n2;
    }

    public JCTextAreaComponent(String string, Applet applet, String string2) {
        super(applet, string2);
        this.setInsets(new Insets(2, 2, 2, 2));
        this.original_bottom_margin = 2;
        this.lines = new JCVector();
        if (string2 == null) {
            this.setName(base + nameCounter++);
        }
        this.setText(string);
        this.setCursorPosition(0);
    }

    public JCTextAreaComponent(Applet applet, String string, int n, int n2) throws IOException {
        this("", n, n2);
        this.readFile(JCFile.createURL(applet, string).openStream());
        this.setCursorPosition(0);
    }

    protected void getParameters() {
        super.getParameters();
        TextAreaConverter.getParams(this);
    }

    public void readFile(Applet applet, String string) throws IOException {
        this.readFile(JCFile.createURL(applet, string).openStream());
    }

    public void readFile(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        String string = dataInputStream.readLine();
        while (string != null) {
            this.appendRow(string);
            string = dataInputStream.readLine();
        }
    }

    public synchronized void setText(String string) {
        if (string == null) {
            string = "";
        }
        this.vert_origin = 0;
        this.horiz_origin = 0;
        super.replaceTextInternal(string, 0, this.num_char);
        if (this.getPeer() != null) {
            this.buildLineTable();
        }
        this.select(this.num_char);
        this.changed = false;
    }

    public void setDoubleBuffer(boolean bl) {
    }

    public void invalidate() {
        super.invalidate();
        this.buffer_image = null;
        this.buffer_image_gc = null;
    }

    public Image getDoubleBufferImage() {
        return this.buffer_image;
    }

    public synchronized Graphics getDoubleBufferGraphics() {
        Image image = this.buffer_image;
        this.buffer_image = BWTUtil.createImage(this, this.buffer_image, this.size().width, this.size().height);
        if (this.buffer_image != image) {
            this.buffer_image_gc = this.buffer_image.getGraphics();
        }
        return this.buffer_image_gc;
    }

    void copyArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw_gc = graphics;
        graphics = this.getDoubleBufferGraphics();
        this.dblbuffer_image = this.getDoubleBufferImage();
        this.getDrawingArea(this.draw_rect);
        graphics.setClip(this.draw_rect);
        graphics.copyArea(n, n2, n3, n4, n5, n6);
        graphics.setClip(n + n5, n2 + n6, n3, n4);
        this.draw_gc.drawImage(this.dblbuffer_image, 0, 0, null);
    }

    public void appendRow(String string) {
        this.append(String.valueOf(string) + '\n');
    }

    public void setInsets(Insets insets) {
        this.startAction(null);
        this.insets = insets;
        this.original_bottom_margin = this.insets.bottom;
        this.adjustInsets();
        this.repaint();
        this.endAction();
    }

    public int getTopRow() {
        return this.top_row;
    }

    public void setTopRow(int n) {
        int n2 = Math.min(this.lines.size() - this.visible_rows, Math.max(0, n));
        if (n2 == this.top_row) {
            return;
        }
        this.top_row = n2;
        this.vert_origin = -999;
        this.repaint();
        this.updateScrollbars();
    }

    public int getTopCharacter() {
        return this.top_char;
    }

    public void setTopCharacter(int n) {
        if (this.top_char == n) {
            return;
        }
        this.top_char = n;
        this.setTopRow(this.positionToRow(n));
    }

    public void setMultiline(boolean bl) {
        this.multiline = bl;
    }

    public boolean getMultiline() {
        return this.multiline;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int n) {
        if (this.rows < 0) {
            throw new IllegalArgumentException("rows less than zero.");
        }
        this.rows = n;
    }

    protected int preferredHeight() {
        return this.rows * this.fm.getHeight();
    }

    public Dimension getMinimumSize(int n) {
        return this.getMinimumSize(this.rows, n);
    }

    public Dimension getMinimumSize(int n, int n2) {
        Object object = JCComponent.LOCK;
        synchronized (object) {
            Dimension dimension = this.getPeer() != null ? new Dimension(n2 * this.fm.charWidth('N'), n * this.fm.getHeight()) : super.minimumSize();
            Object var5_5 = null;
            return dimension;
        }
    }

    protected int maxLines(int n) {
        if (!this.multiline || this.scrolled_window == null) {
            return (int)Math.ceil((double)n / (double)this.fm.getHeight());
        }
        return n / this.fm.getHeight();
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        if (n == this.location().x && n2 == this.location().y && n3 == this.size().width && n4 == this.size().height) {
            return;
        }
        super.reshape(n, n2, n3, n4);
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        this.adjustInsets();
        this.visible_rows = this.maxLines(this.getDrawingArea().height);
        this.bottom_row = Math.max(this.top_row, Math.min(this.top_row + this.visible_rows - 1, this.countRows() - 1));
        this.endAction();
        this.repaint();
    }

    public void addNotify() {
        super.addNotify();
        this.buildLineTable();
    }

    void adjustInsets() {
        if (this.getPeer() == null) {
            return;
        }
        this.insets.bottom = this.original_bottom_margin;
        this.visible_rows = this.maxLines(this.getDrawingArea().height);
        this.insets.bottom += this.getDrawingArea().height - this.visible_rows * this.fm.getHeight();
    }

    protected void updateScrollbars() {
        if (this.update_scrollbars && this.scrolled_window != null) {
            this.scrolled_window.layout();
        }
    }

    protected void buildLineTable() {
        int n;
        int n2 = BWTUtil.countChar(this.text, this.num_char, '\n', 0, this.num_char);
        if (this.lines == null) {
            this.lines = new JCVector(n2);
        } else {
            this.lines.removeAllElements();
            this.lines.ensureCapacity(n2);
        }
        int n3 = 0;
        int n4 = 0;
        while ((n = BWTUtil.indexOf(this.text, this.num_char, 10, n3)) != -1) {
            this.lines.addElement(new TextLine(this, n4++, this.text, n3, n - n3));
            n3 = n + 1;
        }
        this.lines.addElement(new TextLine(this, n4, this.text, n3, this.num_char - n3));
        this.findWidestRow();
    }

    protected synchronized void replaceTextInternal(String string, int n, int n2) {
        int n3;
        this.do_repaint = false;
        super.replaceTextInternal(string, n, n2);
        this.do_repaint = true;
        if (this.getPeer() == null) {
            return;
        }
        this.startAction(null);
        int n4 = this.positionToRow(n);
        int n5 = this.positionToRow(n2);
        int n6 = BWTUtil.countChar(string, '\n', 0, string.length()) + 1;
        int n7 = this.getFirstPosition(n4);
        if (n5 == n4 && n6 == 1) {
            int n8 = this.getWidth(n4);
            this.getLine(n4).replace(string, n - n7, n2 - n7);
            if (n4 == this.widest_row && this.getWidth(n4) < n8 || n4 != this.widest_row && this.getWidth(n4) > n8) {
                this.checkWidestRow(n4);
            }
            this.endAction();
            return;
        }
        if (n2 > n) {
            String string2 = this.getText(n4).substring(0, n - n7);
            String string3 = this.getText(n5).substring(n2 - this.getFirstPosition(n5));
            this.removeLines(n4 + 1, n5);
            this.getLine(n4).setText(String.valueOf(string2) + string3);
            this.updateLineTable(n4);
        }
        if (n6 == 1 || string.length() == 0) {
            this.getLine(n4).insert(string, n);
            this.findWidestRow();
            this.endAction();
            return;
        }
        this.lines.ensureCapacity(this.lines.size() + n6);
        int n9 = 0;
        int n10 = n4;
        while ((n3 = string.indexOf(10, n9)) != -1) {
            String string4 = string.substring(n9, n3);
            if (n10 == n4 && n - n7 + n3 < this.getLine((int)n10).num_char) {
                TextLine textLine = this.getLine(n10);
                String string5 = this.getText(n10).substring(n - n7 + n3);
                textLine.deleteToEnd(n - n7 + n3);
                textLine.append(string4);
                this.insertLine(new TextLine(this, n10 + 1, string5), n10 + 1);
            } else {
                this.insertLine(new TextLine(this, n10, string4), n4 + 1);
            }
            n9 = n3 + 1;
            ++n10;
        }
        if (n10 < this.lines.size()) {
            this.getLine(n10).insert(string.substring(n9), 0);
            this.updateLineTable(n10, n10);
        }
        this.findWidestRow();
        this.endAction();
    }

    void updateLineTable(int n) {
        this.updateLineTable(n, this.lines.size() - 1);
    }

    void updateLineTable(int n, int n2) {
        int n3 = 0;
        if (n > 0) {
            TextLine textLine = (TextLine)this.lines.elementAt(n - 1);
            n3 = textLine.start_pos + textLine.num_char + 1;
        }
        int n4 = n;
        while (n4 <= n2) {
            TextLine textLine = (TextLine)this.lines.elementAt(n4);
            textLine.row = n4++;
            textLine.setStartPos(n3);
            n3 += textLine.num_char + 1;
        }
    }

    void removeLines(int n, int n2) {
        int n3 = Math.min(this.lines.size() - 1, n2);
        while (n3 >= n) {
            this.lines.removeElementAt(n3);
            --n3;
        }
    }

    void insertLine(TextLine textLine, int n) {
        if (n <= this.lines.size()) {
            this.lines.insertElementAt(textLine, n);
        } else {
            this.lines.addElement(textLine);
        }
        this.updateLineTable(n);
    }

    public int positionToX(int n) {
        if (this.getPeer() == null) {
            return 0;
        }
        this.getDrawingArea(this.rect);
        int n2 = 0;
        TextLine textLine = this.getLine(this.positionToRow(n));
        switch (this.alignment) {
            case 2: {
                return this.rect.x + this.rect.width - textLine.getWidthToEnd(n);
            }
            case 1: {
                n2 = (this.rect.width - textLine.getWidth()) / 2;
            }
        }
        return this.rect.x + textLine.getWidth(n) + n2;
    }

    public int positionToY(int n) {
        if (this.getPeer() == null) {
            return 0;
        }
        this.getDrawingArea(this.rect);
        return this.rect.y + this.getRowPosition(this.positionToRow(n));
    }

    public void showPosition(int n) {
        int n2;
        if (this.getPeer() == null || this.bottom_row == -999) {
            return;
        }
        this.getDrawingArea(this.rect);
        int n3 = this.positionToX(n);
        int n4 = this.horiz_origin;
        if (n3 < this.horiz_origin + this.rect.x) {
            n4 = n3 - this.rect.x - 2;
        } else if (n3 > this.horiz_origin + this.rect.x + this.rect.width) {
            n4 = n3 - (this.rect.x + this.rect.width) + 5;
        }
        if (n4 != this.horiz_origin) {
            if (this.scrolled_window != null) {
                this.scrolled_window.scrollHorizontal(n4);
            } else {
                this.horiz_origin = n4;
                this.repaint();
            }
        }
        if ((n2 = this.positionToRow(n)) < this.top_row) {
            n4 = this.getRowPosition(n2);
        } else if (n2 > this.bottom_row) {
            n4 = this.vert_origin + this.getRowPosition(n2 + 1) - this.getRowPosition(this.bottom_row);
        } else {
            return;
        }
        if (this.scrolled_window != null) {
            this.scrolled_window.scrollVertical(n4);
            return;
        }
        this.vert_origin = n4;
        this.repaint();
    }

    protected int getRowHeight(int n) {
        return this.fm.getHeight();
    }

    protected int getRowPosition(int n) {
        n = Math.max(0, Math.min(n, this.lines.size() - 1));
        return n * this.fm.getHeight();
    }

    public int yToRow(int n) {
        int n2;
        if (this.getPeer() == null) {
            return -999;
        }
        this.getDrawingArea(this.draw_rect);
        int n3 = n + this.vert_origin - this.draw_rect.y;
        if (n > this.draw_rect.y + this.draw_rect.height) {
            n2 = this.bottom_row;
            while (n2 <= this.lines.size()) {
                if (n3 < this.getRowPosition(n2)) break;
                ++n2;
            }
            --n2;
        } else if (n < this.draw_rect.y) {
            n2 = this.top_row;
            while (n2 >= 0) {
                if (n3 > this.getRowPosition(n2)) break;
                --n2;
            }
            if (n2 < 0) {
                n2 = 0;
            }
        } else {
            if (this.top_row == this.bottom_row) {
                return this.top_row;
            }
            n2 = this.top_row + 1;
            while (n2 <= Math.min(this.lines.size(), this.bottom_row + 1)) {
                if (n3 < this.getRowPosition(n2)) break;
                if (n2 == this.bottom_row && n2 == this.lines.size() - 1) {
                    return n2;
                }
                ++n2;
            }
            --n2;
        }
        return Math.min(Math.max(0, n2), this.lines.size() - 1);
    }

    protected synchronized void paintComponent(Graphics graphics) {
        if (this.lines.size() == 0) {
            return;
        }
        this.top_row = Math.max(0, Math.min(this.top_row, this.countRows() - 1));
        if (this.vert_origin == -999) {
            this.vert_origin = this.getRowPosition(this.top_row);
        }
        int n = this.top_char = this.getFirstPosition(this.top_row);
        this.bottom_row = Math.max(this.top_row, Math.min(this.top_row + this.visible_rows - 1, this.countRows() - 1));
        Color color = null;
        if (!this.isEnabled()) {
            color = graphics.getColor();
            graphics.setColor(Color.lightGray.darker().darker());
        }
        int n2 = this.top_row;
        while (n2 <= this.bottom_row) {
            TextLine textLine = this.getLine(n2);
            textLine.setStartPos(n);
            n += textLine.num_char + 1;
            textLine.paint(graphics);
            ++n2;
        }
        if (!this.isEnabled()) {
            graphics.setColor(color);
        }
    }

    public Rectangle getBounds(int n, boolean bl) {
        if (n < 0 || n >= this.lines.size()) {
            return null;
        }
        this.getDrawingArea(this.draw_rect);
        this.draw_rect.reshape(this.draw_rect.x - (bl ? this.horiz_origin : 0), this.draw_rect.y + this.getRowPosition(n) - (bl ? this.vert_origin : 0), Math.max(this.draw_rect.width, this.preferredWidth()), this.getRowHeight(n));
        return this.draw_rect;
    }

    protected synchronized void repaintPositions(Point point, Point point2) {
        if (point.equals(point2)) {
            return;
        }
        point.y -= this.vert_origin;
        point2.y -= this.vert_origin;
        if (point.y == point2.y) {
            super.repaintPositions(point, point2);
            return;
        }
        int n = this.yToRow(point.y);
        int n2 = this.yToRow(point2.y);
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (n4 < this.top_row || n3 > this.bottom_row) {
            return;
        }
        int n5 = Math.max(this.top_row, n3);
        while (n5 <= Math.min(this.bottom_row, n4)) {
            Rectangle rectangle = this.getBounds(n5, true);
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n5;
        }
    }

    protected int getNumChar(int n) {
        if (n >= 0 && n < this.lines.size()) {
            return ((TextLine)this.lines.elementAt((int)n)).num_char;
        }
        return 0;
    }

    protected int getWidth(int n) {
        return ((TextLine)this.lines.elementAt((int)n)).width;
    }

    public int getVisibleRows() {
        return this.visible_rows;
    }

    public String getText(int n) {
        if (n < 0 || n >= this.lines.size()) {
            return null;
        }
        TextLine textLine = (TextLine)this.lines.elementAt(n);
        return new String(textLine.text, 0, textLine.num_char);
    }

    protected TextLine getLine(int n) {
        if (n >= 0 && n < this.lines.size()) {
            return (TextLine)this.lines.elementAt(n);
        }
        return null;
    }

    protected int getFirstPosition(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            TextLine textLine = (TextLine)this.lines.elementAt(n3);
            textLine.setStartPos(n2);
            n2 += textLine.num_char + 1;
            ++n3;
        }
        return n2;
    }

    protected int positionToRow(int n) {
        int n2 = 0;
        int n3 = 0;
        if (n >= this.top_char) {
            n2 = this.top_char;
            n3 = this.top_row;
        }
        while (n3 < this.lines.size()) {
            if (n < n2) {
                return n3 - 1;
            }
            n2 += this.getNumChar(n3) + 1;
            ++n3;
        }
        return this.lines.size() - 1;
    }

    protected int getWidestRow() {
        if (this.widest_row == -999) {
            this.findWidestRow();
        }
        if (this.widest_row == -999) {
            return 0;
        }
        TextLine textLine = this.getLine(this.widest_row);
        if (textLine != null) {
            return textLine.width;
        }
        return 0;
    }

    protected void checkWidestRow(int n) {
        TextLine textLine;
        if (n == this.widest_row) {
            this.findWidestRow();
            return;
        }
        if (this.widest_row == -999) {
            this.widest_row = n;
            return;
        }
        TextLine textLine2 = this.getLine(n);
        if (textLine2 != null && (textLine = this.getLine(n)) != null && textLine2.width > textLine.width) {
            this.widest_row = n;
            return;
        }
        this.findWidestRow();
    }

    protected void findWidestRow() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.lines.size()) {
            int n3 = ((TextLine)this.lines.elementAt((int)n2)).width;
            if (n3 > n) {
                this.widest_row = n2;
                n = n3;
            }
            ++n2;
        }
    }

    protected int countRows() {
        return this.lines.size();
    }

    protected int getCurrentRow() {
        return this.positionToRow(this.cursor_pos);
    }

    protected int getCurrentFirstPosition() {
        return this.getFirstPosition(this.getCurrentRow());
    }

    public int pointToPosition(int n, int n2) {
        int n3 = this.yToRow(n2);
        if (n3 == -999) {
            return 0;
        }
        return this.getLine(n3).xToPosition(n);
    }

    protected void scrollLineEnd(Event event) {
        TextLine textLine = this.getLine(this.getCurrentRow());
        if (textLine != null) {
            this.selectCursorPos(event, this.getFirstPosition(this.getCurrentRow()) + textLine.num_char);
        }
    }

    protected void scrollLineBegin(Event event) {
        this.selectCursorPos(event, this.getFirstPosition(this.getCurrentRow()));
    }

    void selectCursorPos(Event event, int n) {
        this.startAction(event);
        if (event.shiftDown()) {
            int n2 = this.select_start;
            int n3 = this.select_end;
            if (this.cursor_pos < n3) {
                n2 = Math.min(this.num_char, n);
                this.setCursorPosition(n2);
            } else {
                n3 = Math.min(this.num_char, n);
                this.setCursorPosition(n3);
            }
            this.select(n2, n3, 0);
        } else {
            this.select(n);
        }
        this.endAction();
    }

    private void moveCursor(Event event, int n, boolean bl) {
        int n2 = this.getCurrentRow();
        int n3 = Math.min(this.lines.size() - 1, Math.max(0, n2 + n));
        if (n3 == n2) {
            return;
        }
        int n4 = this.top_row;
        TextLine textLine = this.getLine(n3);
        textLine.setStartPos(this.getFirstPosition(n3));
        int n5 = Math.min(textLine.num_char, this.cursor_pos - this.getLine((int)n2).start_pos);
        this.selectCursorPos(event, textLine.start_pos + n5);
        if (bl) {
            this.setTopRow(n4 + n);
        }
    }

    protected void moveNextLine(Event event) {
        this.moveCursor(event, 1, false);
    }

    protected void movePreviousLine(Event event) {
        this.moveCursor(event, -1, false);
    }

    protected void scrollNextPage(Event event) {
        this.moveCursor(event, this.visible_rows - 1, true);
    }

    protected void scrollPreviousPage(Event event) {
        this.moveCursor(event, -this.visible_rows + 1, true);
    }

    protected boolean insertNewLine(Event event) {
        if (!this.editable) {
            return false;
        }
        this.startAction(event);
        this.insert("\n", this.cursor_pos);
        this.endAction();
        this.changed = true;
        return true;
    }

    public boolean keyDown(Event event, int n) {
        boolean bl = true;
        boolean bl2 = true;
        if (n == 1004) {
            this.movePreviousLine(event);
        } else if (n == 1005) {
            this.moveNextLine(event);
        } else if (n == 1002) {
            this.scrollPreviousPage(event);
        } else if (n == 1003) {
            this.scrollNextPage(event);
        } else if (n == 10) {
            bl = this.insertNewLine(event);
        } else {
            bl2 = false;
        }
        if (!bl) {
            this.beep();
        }
        if (bl2) {
            return true;
        }
        return super.keyDown(event, n);
    }

    public int getHorizOrigin() {
        return this.horiz_origin;
    }

    public void setHorizOrigin(int n) {
        this.horiz_origin = n;
    }

    public int getVertOrigin() {
        return this.vert_origin;
    }

    public void setVertOrigin(int n) {
        this.vert_origin = Math.max(0, n);
        this.top_row = 0;
        while (this.top_row < this.lines.size()) {
            if (this.getRowPosition(this.top_row) + this.getRowHeight(this.top_row) > n) {
                return;
            }
            ++this.top_row;
        }
    }
}

